#!/bin/sh
. /etc/iproute2/script/gateway-mgt-function

SYNONETD_TOOL="/usr/syno/sbin/synonetdtool"

is_wifi_client()
{
	echo ${IFNAME} | grep -q "^wlan"
	if [ $? -ne 0 ]; then
		return 1
	fi
	local topology=`/bin/get_key_value /etc/synoinfo.conf net_topology`
	if [ "client" != "${topology}" ]; then
		return 1
	fi
	# wpa connect and disconnect will pop alot of up-down event
	# make sure wpa is really connected
	local wpa_ps=`/bin/ps ww | /bin/grep wpa_supplicant | /bin/grep ${IFNAME}`
	if [ -z "$wpa_ps" ]; then
		return 1
	fi

	return 0
}

add_interface()
{
	local GATEWAY="NULL"
	local DNS="NULL"
	local IFCFG_FILE="/etc/sysconfig/network-scripts/ifcfg-${IFNAME}"
	local GATEWAY_DATABASE="/etc/iproute2/config/gateway_database"

	if [ ! -f ${IFCFG_FILE} ]; then
		return
	fi
	local BOOTPROTO=`get_key_value ${IFCFG_FILE} BOOTPROTO`
	if [ "${BOOTPROTO}" = "none" ]; then
		return
	fi

	local BRIDGE=`get_key_value ${IFCFG_FILE} BRIDGE`

	if [ "${BOOTPROTO}" = "dhcp" -a -z "${BRIDGE}"]; then
		restart dhcp-client IFACE=${IFNAME}
	elif [ "${BOOTPROTO}" = "static" -a -z "${BRIDGE}" ]; then
		GATEWAY=`get_section_key_value ${GATEWAY_DATABASE} ${IFNAME} gateway`
		if test -z "$GATEWAY" ; then
			GATEWAY="NULL"
		fi
		DNS=`get_section_key_value ${GATEWAY_DATABASE} ${IFNAME} dns`
		if test -z "$DNS" ; then
			DNS="NULL"
		fi
		/usr/syno/sbin/synobootupcheck --check-network
		NETWORK_CHK=$?
		/usr/syno/bin/synobootseq --is-ready
		REBOOT_CHK=$?
		if [ "0" = "$NETWORK_CHK" -a "0" = "$REBOOT_CHK" ]; then
			# Waiting for /usr/syno/bin/servicetool --restart link &
			synoservicecfg --restart samba &
			synoservicecfg --restart nmbd &
			synoservicecfg --restart winbindd &
		fi
	fi

	${SYNONETD_TOOL} --add-gateway-info -4 -2 ${IFNAME} ${GATEWAY} ${DNS} ethernet

	if [ ! -z "${BRIDGE}" ]; then
		${SYNONETD_TOOL} --set-slave-data -4 ${IFNAME} yes
	fi

	set_default_gateway_interface

	${SYNONETD_TOOL} --refresh-gateway -4
	if [ "${GATEWAY}" != "NULL" ]; then
		local enable_multi_gateway=`/bin/get_key_value /etc/synoinfo.conf multi_gateway`
		if [ "xyes" = "x${enable_multi_gateway}" ]; then
			local IPADDR=`get_key_value ${IFCFG_FILE} IPADDR`
			${SYNONETD_TOOL} --add-policy-route-rule -4 multi-gateway ${IFNAME} NULL NULL ${GATEWAY}
			${SYNONETD_TOOL} --refresh-route-table -4 ${IFNAME} ${IPADDR}
		fi
	fi
}

add_interface_v6()
{
	local GATEWAY="NULL"
	local DNS="NULL"
	local IFCFG_FILE="/etc/sysconfig/network-scripts/ifcfg-${IFNAME}"
	if [ ! -f ${IFCFG_FILE} ]; then
		return
	fi
	local IPV6INIT=`get_key_value ${IFCFG_FILE} IPV6INIT`
	if [ "${IPV6INIT}" = "off" ]; then
		return
	fi

	local BRIDGE=`get_key_value ${IFCFG_FILE} BRIDGE`

	if [ "${IPV6INIT}" = "static" -a -z "${BRIDGE}" ]; then
		GATEWAY=`get_key_value ${IFCFG_FILE} IPV6_DEFAULTGW`
		if test -z "$GATEWAY" ; then
			GATEWAY="NULL"
		fi
		DNS=`get_key_value ${IFCFG_FILE} IPV6DNS`
		if test -z "$DNS" ; then
			DNS="NULL"
		fi
	fi

	${SYNONETD_TOOL} --add-gateway-info -6 -2 ${IFNAME} ${GATEWAY} ${DNS} ethernet

	if [ ! -z "${BRIDGE}" ]; then
		${SYNONETD_TOOL} --set-slave-data -6 ${IFNAME} yes
	fi

	set_default_gateway_interface

	${SYNONETD_TOOL} --refresh-gateway -6
	if [ "${GATEWAY}" != "NULL" ]; then
		local enable_multi_gateway=`/bin/get_key_value /etc/synoinfo.conf multi_gateway`
		if [ "xyes" = "x${enable_multi_gateway}" ]; then
			local NUM=`/sbin/ifconfig ${IFNAME} | grep inet6 | wc -l`
			local IPADDR=""
			for i in `seq 1 $NUM`
			do
				local IP=`ifconfig eth1 | grep inet6 | sed -n ${i}p | awk '{print $3}'| cut -d "/" -f1`
				if [ ! -z "$IP" ]; then
					if [ $i -eq 1 ]; then
						IPADDR=${IP}
					else
						IPADDR="${IPADDR},${IP}"
					fi
				fi
			done
			if [ ! -z "$IPADDR" ]; then
				${SYNONETD_TOOL} --add-policy-route-rule -6 multi-gateway ${IFNAME} NULL NULL ${GATEWAY}
				${SYNONETD_TOOL} --refresh-route-table -6 ${IFNAME} ${IPADDR}
			fi
		fi
	fi
}

case $1 in
	--sdk-mod-ver)
	#Print SDK support version
	echo "1.0";
	;;
	--name)
	#Print package name
	echo "SynorouterClient"
	;;
	--pkg-ver)
	#Print package version
	echo "1.0";
	;;
	--vendor)
	#Print package vendor
	echo "Synology";
	;;
	--post)
		ifconfig ${IFNAME} > /dev/null 2>&1
		if [ $? -ne 0 ]; then
			return;
		fi
		is_wifi_client
		local WIFI_CLIENT=$?
		is_wired_interface ${IFNAME}
		local WIRED_INTERFACE=$?
		if [ $WIFI_CLIENT -eq 0 -o $WIRED_INTERFACE -eq 0 ]; then
			add_interface
			add_interface_v6
			return
		fi
	;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

